#include <gb.h>
#include <stdarg.h>

#include "menu.h"
#include "basechar.h"
#include "extchar.h"
#include "gbsup.h"

#define MS_BUFSIZE  64

#define MD_PrintAt(x,y,f,s) \
  { \
    static char MS_Buffer[MS_BUFSIZE]; \
    sprintf(MS_Buffer,f,s); \
    set_bkg_tiles(x,y,strlen(MS_Buffer),1,(unsigned char*)MS_Buffer); \
  }

#define MS_ClrScr  set_bkg_tiles(0, 0, XMAX, YMAX, (unsigned char*)MS_Blank)
#define XMAX              20
#define YMAX              18
#define DT_MAX           200
#define DT_DEC           100
#define DT_MIN             0

#define BASECHAR           0
#define EXTCHAR          128

#define LOCO_ALL_OFF       0
#define LOCO_FWD_ON     0x80
#define LOCO_BWD_ON     0x40
#define HORN_ON         0xC0
#define LOCO_DIRBITS    0xC0
#define LOCO_SPEEDBITS  0x1F
#define LOCO_DATA_COL      7

#define OBJECT_LINE        1
#define STATUS_LINE        3
#define B_LEFT             0
#define DELTA_ROW          8
#define COL_STEP           2
#define MENU_LINE         14
#define MD_ADDRSEL_POS   2,5
#define SWITCH_DATA_POS   10

static UBYTE MS_State;
static char MS_Buffer[MS_BUFSIZE];
static char _MS_Blank[XMAX][YMAX];
static char *MS_Blank=(char*) _MS_Blank; 
static UWORD DelTime;

UBYTE InitMenu( void )
{
  int i;
  set_bkg_data(BASECHAR, basecharsLen, basechars );
  set_bkg_data(EXTCHAR, extcharsLen, extchars );
  for(i=0; i<XMAX*YMAX; i++) MS_Blank[i]=0;
  MS_ClrScr;
  SHOW_BKG;
  DISPLAY_ON;
  MS_State= MS_LOCO;
  MenuDisplay( MD_ALL );
  return MS_State;
}

UBYTE MenuInput( void )
{
  UBYTE tmp;

  if( !joypad() ) DelTime=DT_MAX;
  switch( WaitKeyPress() )
  {
    case J_START:
    {
      UBYTE x;
      x=GetData( MS_LOCO );
      if( x )
      {
        SetData( MS_LOCO, x | HORN_ON );
          WaitKeyChange();
        SetData( MS_LOCO, x );
      }
      else WaitKeyChange();
    }
    break;

    case J_SELECT:
      switch( MS_State )
      {
        case MS_LOCO:
          if( !GetData( MS_State ) )
            SetData( MS_State, LOCO_FWD_ON );
          else
          {
              MD_PrintAt( 10, 0, "  ", 0);
              SetData( MS_State, LOCO_ALL_OFF );
          }
        break;

        case MS_SWITCH:
        case MS_SIGNAL:
          SwitchData( MS_State );
        break;

        case MS_LAMP:
          LampData( MS_State );
        break;
      }
      MenuDisplay( MD_VAR );
      WaitKeyChange();
    break;

    case J_SELECT + J_A:
      if( MS_State == MS_LOCO )
      {
        /* Loco couple here */
        MD_PrintAt( 10, 0, "C ", 0);
      }
      WaitKeyRelease();
    break;



    case J_B:
      switch( MS_State )
      {
        case MS_LOCO:   MS_State=MS_SWITCH; break;
        case MS_SWITCH: MS_State=MS_SIGNAL; break;
        case MS_SIGNAL: MS_State=MS_LAMP;   break;
        case MS_LAMP:   MS_State=MS_SWITCH; break;
      }
      MenuDisplay( MD_ALL );
      WaitKeyRelease();
    break;

    case J_A:
      MS_State=MS_LOCO;
      MenuDisplay( MD_ALL );
      WaitKeyRelease();
    break;

    case J_DOWN:
      switch(MS_State)
      {
        case MS_LOCO:
          if( GetData(MS_State) )
          {
            DecData( MS_State );
            MenuDisplay( MD_VAR );
          }
          if( (GetData(MS_State)&LOCO_SPEEDBITS) == 0 ) WaitKeyChange();
        break;
        default:
          AddAddr(MS_State, DELTA_ROW );
          MenuDisplay( MD_VAR );
          MS_Delay();
        break;
      }
    break;

    case J_UP:
      switch(MS_State)
      {
        case MS_LOCO:
          if( GetData(MS_State) )
          {
            IncData( MS_State );
            MenuDisplay( MD_VAR );
          }
          if( (GetData(MS_State)&LOCO_SPEEDBITS) == 0 ) WaitKeyChange();
        break;
        default:
          SubAddr(MS_State, DELTA_ROW );
          MenuDisplay( MD_VAR );
          MS_Delay();
        break;
      }
    break;

    case J_LEFT:
      DecAddr(MS_State);
      MenuDisplay( MD_VAR );
      MS_Delay();
    break;

    case J_RIGHT:
      IncAddr(MS_State);
      MenuDisplay( MD_VAR );
      MS_Delay();
    break;

    default:
      WaitKeyRelease();
    break;
  }
  return MS_State;
}

UBYTE MenuDisplay( UBYTE mask )
{
  if( mask & MD_FIX ) MS_ClrScr; 
  switch( MS_State )
  {
    case MS_LOCO:
      if( mask & MD_FIX ) MD_Loco_Fix();
      if( mask & MD_VAR ) MD_Loco_Var();
    break;
    case MS_SWITCH:
      if( mask & MD_FIX ) MD_Switch_Fix();
      if( mask & MD_VAR ) MD_Switch_Var();
    break;
    case MS_SIGNAL:
      if( mask & MD_FIX ) MD_Signal_Fix();
      if( mask & MD_VAR ) MD_Signal_Var();
    break;
    case MS_LAMP:
      if( mask & MD_FIX ) MD_Lamp_Fix();
      if( mask & MD_VAR ) MD_Lamp_Var();
    break;
  }
  return 0;
}

UBYTE MD_AddrSel( UBYTE ox, UBYTE oy )
{
  UBYTE i, j;
  for(j=0; j<DELTA_ROW; j++)
    for(i=EXTCHAR; i<EXTCHAR+DELTA_ROW; i++)
      MD_PrintAt( COL_STEP*(i-EXTCHAR)+ox, j+oy, "%c", i+j*DELTA_ROW );
  return 0;
}

UBYTE MD_AddrMark( UBYTE ox, UBYTE oy, UBYTE a )
{
  static UBYTE x, y;
  if( x && y )
  {
    MD_PrintAt( x-1, y, "%c", ' ' );
    MD_PrintAt( x+1, y, "%c", ' ' );
  }
  x=COL_STEP*(a%DELTA_ROW)+ox;
  y=a/DELTA_ROW+oy;
  MD_PrintAt( x-1, y, "%c", '[' );
  MD_PrintAt( x+1, y, "%c", ']' );
  return 0;
}

UBYTE MD_Loco_Fix( void )
{
  MD_PrintAt( B_LEFT, OBJECT_LINE, "%s", "Lok:             \xcb\xc9" );
  MD_PrintAt( B_LEFT, STATUS_LINE, "%s", "Fahrt:           \xcc\xca" );
  MD_PrintAt( B_LEFT, MENU_LINE,   "%s", "A:      Loks" );
  MD_PrintAt( B_LEFT, MENU_LINE+1, "%s", "B:      Weichen");
  MD_PrintAt( B_LEFT, MENU_LINE+2, "%s", "Select: Lok ein/aus" );
  MD_PrintAt( B_LEFT, MENU_LINE+3, "%s", "Start:  Hupe");
  return 0;
}

UBYTE MD_Loco_Var( void )
{
  MD_PrintAt( LOCO_DATA_COL, OBJECT_LINE, "%u ", GetAddr(MS_State) );
  switch( GetData(MS_State) & LOCO_DIRBITS )
  {
    case LOCO_FWD_ON: MD_PrintAt( LOCO_DATA_COL, STATUS_LINE, "%s", "  \xC8\xC7 \xC9 " ); break;
    case LOCO_BWD_ON: MD_PrintAt( LOCO_DATA_COL, STATUS_LINE, "%s", "\xCB \xC8\xC7   " ); break;
    case LOCO_ALL_OFF: MD_PrintAt( LOCO_DATA_COL, STATUS_LINE, "%s", "  AUS  " ); break;
  }
  MD_PrintAt( 2*LOCO_DATA_COL, STATUS_LINE, "%u ", GetData( MS_State ) & LOCO_SPEEDBITS );
  return 0;
}

UBYTE MD_Switch_Fix( void )
{
  MD_PrintAt( B_LEFT, OBJECT_LINE, "%s", "Weiche:       \xcb\xc9 \xcc\xca" );
  MD_PrintAt( B_LEFT, STATUS_LINE, "%s", "Stellung:     Select");
  MD_PrintAt( B_LEFT, MENU_LINE+1, "%s", "A:     Loks");
  MD_PrintAt( B_LEFT, MENU_LINE+2, "%s", "B:     Signale");
  MD_PrintAt( B_LEFT, MENU_LINE+3, "%s", "Start: Hupe");
  MD_AddrSel( MD_ADDRSEL_POS );
  return 0;
}

UBYTE MD_Switch_Var( void )
{
  MD_PrintAt( SWITCH_DATA_POS, OBJECT_LINE, "%u ", GetAddr(MS_State) );
  switch( GetData(MS_State) )
  {
    case (int)0x80: MD_PrintAt( SWITCH_DATA_POS, STATUS_LINE, "%c ", 0xC1 ); break;
    case (int)0x40: MD_PrintAt( SWITCH_DATA_POS, STATUS_LINE, "%c ", 0xC2 ); break;
  }
  MD_AddrMark( MD_ADDRSEL_POS, GetAddr(MS_State) );
  return 0;
}

UBYTE MD_Signal_Fix( void )
{
  MD_PrintAt( B_LEFT, OBJECT_LINE, "%s", "Signal:       \xcb\xc9 \xcc\xca" );
  MD_PrintAt( B_LEFT, STATUS_LINE, "%s", "Stellung:     Select");
  MD_PrintAt( B_LEFT, MENU_LINE+1, "%s", "A:     Loks");
  MD_PrintAt( B_LEFT, MENU_LINE+2, "%s", "B:     Lampen");
  MD_PrintAt( B_LEFT, MENU_LINE+3, "%s", "Start: Hupe");
  MD_AddrSel( MD_ADDRSEL_POS );
  return 0;
}

UBYTE MD_Signal_Var( void )
{
  MD_PrintAt( SWITCH_DATA_POS, OBJECT_LINE, "%u ", GetAddr(MS_State) );
  switch( GetData(MS_State) )
  {
    case (int)0x80: MD_PrintAt( SWITCH_DATA_POS, STATUS_LINE, "%c ", 0xC3 ); break;
    case (int)0x40: MD_PrintAt( SWITCH_DATA_POS, STATUS_LINE, "%c ", 0xC4 ); break;
  }
  MD_AddrMark( MD_ADDRSEL_POS, GetAddr(MS_State) );
  return 0;
}

UBYTE MD_Lamp_Fix( void )
{
  MD_PrintAt( B_LEFT, OBJECT_LINE, "%s", "Licht:        \xcb\xc9 \xcc\xca" );
  MD_PrintAt( B_LEFT, STATUS_LINE, "%s", "Stellung:     Select");
  MD_PrintAt( B_LEFT, MENU_LINE+1, "%s", "A:     Loks");
  MD_PrintAt( B_LEFT, MENU_LINE+2, "%s", "B:     Weichen");
  MD_PrintAt( B_LEFT, MENU_LINE+3, "%s", "Start: Hupe");
  MD_AddrSel( MD_ADDRSEL_POS );
  return 0;
}

UBYTE MD_Lamp_Var( void )
{
  MD_PrintAt( SWITCH_DATA_POS, OBJECT_LINE, "%u ", GetAddr(MS_State) );
  switch( GetData(MS_State) )
  {
    case (int)0: MD_PrintAt( SWITCH_DATA_POS, STATUS_LINE, "%c ", 0xC5 ); break;
    case (int)159: MD_PrintAt( SWITCH_DATA_POS, STATUS_LINE, "%c ", 0xC6 ); break;
  }
  MD_AddrMark( MD_ADDRSEL_POS, GetAddr(MS_State) );
  return 0;
}

int MS_Delay( void )
{
  delay( DelTime );
  if( DelTime>(DT_DEC+DT_MIN) ) DelTime-=DT_DEC;
  return 0;
}

